<?php

// https://www.php.net/manual/en/function.ssh2-sftp.php#120853
class SFTPConnection {

    private $connection;
    private $sftp;

	public function getConnection() {
		return $this->connection;
	}

    public function __construct($host, $port=22) {
        $this->connection = @ssh2_connect($host, $port);
        if (! $this->connection)
            throw new Exception("Could not connect to SFTP host $host on port $port.");
    }

    public function login($username, $password) {
        if (! @ssh2_auth_password($this->connection, $username, $password))
            throw new Exception("Could not authenticate with username $username " . "and password $password.");
        $this->sftp = ssh2_sftp($this->connection);
        return $this->sftp !== false;
    }

    public function uploadFile($local_file, $remote_file) {
        $sftp = $this->sftp;
		$remote_dir = dirname($remote_file);
		if (!file_exists("ssh2.sftp://$sftp$remote_dir")) {
			mkdir("ssh2.sftp://$sftp$remote_dir", 0777, true);
		}
        $stream = @fopen("ssh2.sftp://$sftp$remote_file", 'w');
        if (! $stream)
            throw new Exception("Could not open SFTP file for writing: $remote_file");
        $data_to_send = @file_get_contents($local_file);
        if ($data_to_send === false)
            throw new Exception("Could not open local file: $local_file.");
        if (@fwrite($stream, $data_to_send) === false)
            throw new Exception("Could not send data from file: $local_file.");
        @fclose($stream);
		return true;
    }

	public function uploadFileContent($content, $remote_file) {
		$sftp = $this->sftp;
		$remote_dir = dirname($remote_file);
		if (!file_exists("ssh2.sftp://$sftp$remote_dir")) {
			mkdir("ssh2.sftp://$sftp$remote_dir", 0777, true);
		}
		$stream = @fopen("ssh2.sftp://$sftp$remote_file", 'w');
		if (! $stream)
			throw new Exception("Could not open SFTP file for writing: $remote_file");
		if (@fwrite($stream, $content) === false)
			throw new Exception("Could not send data to file: $remote_file.");
		@fclose($stream);
		return true;
	}

    function scanFilesystem($remote_file) {
        $sftp = $this->sftp;
        $dir = "ssh2.sftp://$sftp$remote_file";
        $tempArray = array();

        if (is_dir($dir)) {
            if ($dh = opendir($dir)) {
                while (($file = readdir($dh)) !== false) {
                    $filetype = filetype($dir . $file);
                    if($filetype == "dir") {
                        $tmp = $this->scanFilesystem($remote_file . $file . "/");
                        foreach($tmp as $t) {
                            $tempArray[] = $file . "/" . $t;
                        }
                    } else {
                        $tempArray[] = $file;
                    }
                }
                closedir($dh);
            }
        }

        return $tempArray;
    }

    public function receiveFile($remote_file, $local_file) {
        $sftp = $this->sftp;
        $stream = @fopen("ssh2.sftp://$sftp$remote_file", 'r');
        if (! $stream)
            throw new Exception("Could not open SFTP file for reading: $remote_file");
        $contents = fread($stream, filesize("ssh2.sftp://$sftp$remote_file"));
        file_put_contents ($local_file, $contents);
        @fclose($stream);
    }

	public function statFile($remote_file) {
		$statinfo = ssh2_sftp_stat($this->sftp, $remote_file);
		return $statinfo;
	}

	public function hashFile($remote_file) {
		$sftp = $this->sftp;
		$hash = hash_file('sha256', "ssh2.sftp://$sftp$remote_file");
		return $hash;
	}

	public function fileExists($remote_file) {
		$statinfo = @ssh2_sftp_stat($this->sftp, $remote_file);
		return $statinfo !== false;
	}

    public function deleteFile($remote_file) {
        $sftp = $this->sftp;
        unlink("ssh2.sftp://$sftp$remote_file");
    }

}

?>
