#!/bin/sh

#
# backend.sh
#
# Developed by Ondrej Jombik <jombik@platon.net>
# Copyright (c) 2024 Platon Technologies, s.r.o.
# All rights reserved.
#
# Changelog:
# 2024-08-01 - created
#

# $Platon$

#
# Check tools
#

PHP_BIN="` which php `";
if [ -z "$PHP_BIN" ]; then
	echo "ERROR: php not found";
	exit 2;
fi

DATE_BIN="` which date `";
if [ -z "$PHP_BIN" ]; then
	echo "ERROR: date not found";
	exit 3;
fi

#
# Input arguments
#

if [ "$#" -ne 1 ]; then
	echo "Usage: $0 <max-time>"
	exit 1;
fi

MAX_TIME="$1"

if ! echo "$MAX_TIME" | grep -qE '^[1-9][0-9]*$'; then
	echo "ERROR: max-time must be number, received: $MAX_TIME";
	exit 4;
fi

SCRIPT_PATH="$( cd -- "$(dirname "$0")" >/dev/null 2>&1 ; pwd -P )"
SCRIPT_NAME="` basename \"$0\" `";
CURDATE="` \"$DATE_BIN\" '+%Y-%m-%d' `";
LOG_DIR="/var/log/platon-cdn";
LOG_FILE="$LOG_DIR/platon-cdn-$CURDATE.log";

#
# Execute
#

"$PHP_BIN" "$SCRIPT_PATH"/backend.php --coloured --run-in-cron --max-time="$MAX_TIME" >>"$LOG_FILE";
rc="$?";
exit "$rc";

