<h1 class="wp-heading-inline"><span class="platon-logo-simple"></span>Platon CDN &#8594;Logs Explorer</h1>
<hr class="wp-header-end">

<div class="card w100">
	<h2>Settings</h2>
	<div class="log-settings">
		<span for="logpath">Path to logs:&nbsp;</span>
		<span id="logpath_view">
			<span><?php $logpath = $GLOBALS['platon_cdn_plugin']->logPath(); echo empty($logpath) ? '-none-' : $logpath; ?></span>
			<a href="Javascript:void(0);" onclick="logPathEdit();"><span class="icon-edit"></span></a>
		</span>
		<span id="logpath_edit" class="hide log-edit">
			<form method="post" action="<?php menu_page_url('platon-cdn/admin/view.php'); ?>&logpath-save">
				<input type="text" name="logpath" value="<?php echo $logpath; ?>" style="width:50vw;" >
				<input type="submit" value="Save" class="page-title-action">
			</form>
		</span>
	</div>
</div>

<div class="card w100 log-explorer">
	<div class="log-filelist">
		<h3>List of files</h3>
		<?php if (is_array($GLOBALS['platon_cdn_plugin']->logFiles())) foreach ($GLOBALS['platon_cdn_plugin']->logFiles() as $key => $logfile) { ?>
		<a href="Javascript:void(0);" onclick="logView('<?php echo $logfile['name']; ?>');"><?php echo $logfile['name']; ?></a>
		<?php } ?>
	</div>
	<div class="log-viewer" id="log_viewer">
		<h3 id="log_filename"></h3>
	</div>
</div>

<br>
<a href="<?php menu_page_url('platon-cdn/admin/view.php'); ?>" class="button">Back</a>

<script>
// Logs Explorer
function logPathEdit() {
	document.getElementById('logpath_view').classList.add('hide');
	document.getElementById('logpath_edit').classList.remove('hide');
}
function logView(filename) {
	const log_viewer = document.getElementById('log_viewer');
	log_viewer.innerHTML = 'loading <strong>'+filename+'</strong> ...';
	const formData = new FormData();
	formData.append('filename', filename);
	const options = {
		method: 'POST',
		body: formData
	};
	fetch('<?php menu_page_url('platon-cdn/admin/view.php'); ?>&logpath-fetch', options)
	.then(response => {
		if (!response.ok) {
			log_viewer.innerHTML = 'ERROR: Network response was not ok';
		}
		return response.json();
	})
	.then(data => {
		// Handle the JSON data
		//console.log(data);
		if (data.status != 'OK') {
			log_viewer.innerHTML = 'ERROR: '+data.message;
			return;
		}
		log_viewer.innerHTML = '<h3>'+filename+'</h3>'
			+ '<pre>'+data.content+'</pre>';
	})
	.catch(error => {
		// Handle any errors that occurred during the fetch
		log_viewer.innerHTML = 'ERROR: '+error.message;
		console.error('Fetch error:', error);
	});

}
</script>