<div class="wrap">

<?php if (isset($_REQUEST['new'])) { ?>
<h1 class="wp-heading-inline">Create New Request</h1>
<div class="card">
	<form method="post" action="<?php menu_page_url('cluster-commands/admin/view.php'); ?>&save">
	<table width="100%">
	<tr>
		<td>Command</td>
		<td>
			<select name="command">
			<option></option>
			<?php foreach ($GLOBALS['platon_cluster_commands']->commands() as $command => $name) { ?>
			<option value="<?php echo $command; ?>"><?php echo $name; ?></option>
			<?php } ?>
			</select>
		</td>
	<tr>
	</tr>
		<td colspan="2" align="right">
			<input type="submit" value="Create" class="page-title-action">
			<a href="<?php menu_page_url('cluster-commands/admin/view.php'); ?>" class="button">Cancel</a>
		</td>
	</tr>
	</table>
	</form>
</div>
<?php } else { ?>
<h1 class="wp-heading-inline">Cluster Commands</h1>
<a href="<?php menu_page_url('cluster-commands/admin/view.php'); ?>&new" class="page-title-action">Create new request</a>
<small style="float:right;">version <?php echo Platon_ClusterCommands::$version; ?></small>

<hr class="wp-header-end">

<div class="card w100">
	<h2>Shortcuts</h2>
	<?php foreach ($GLOBALS['platon_cluster_commands']->commands() as $command => $name) { ?>
	<a href="<?php menu_page_url('cluster-commands/admin/view.php'); ?>&shortcut&command=<?php echo $command; ?>" class="page-title-action"><?php echo $name; ?></a>
	<?php } ?>
</div>

<hr class="wp-header-end">

<div class="card w100">
	<h2 class="wp-heading-inline">Requests</h2>
	<a href="<?php menu_page_url('cluster-commands/admin/view.php'); ?>" class="page-title-action">Refresh</a>
	<table width="100%" rules="rows">
	<tr>
		<th align="right" style="padding-right: 10px;">#</th>
		<th align="left">Date of request</th>
		<th align="left">Command</th>
		<th align="left">Created by</th>
		<th align="left">Answers</th>
	</tr>
<?php $requests = $GLOBALS['platon_cluster_commands']->getRequests(true, 25); if (is_array($requests)) foreach ($requests as $request) { ?>
<?php $user = get_userdata($request['request']['user_id']); ?>
	<tr>
		<td valign="top" align="right" style="padding-right: 10px;"><?php echo $request['request']['command_id']; ?></td>
		<td valign="top"><?php echo $request['request']['command_dt']; ?></td>
		<td valign="top"><b><?php echo $GLOBALS['platon_cluster_commands']->commands()[$request['request']['command']]; ?></b></td>
		<td valign="top"><?php echo $user->display_name; ?></td>
		<td valign="top">
		<?php $answers = array(); ?>
		<?php
			if (is_array($request['answers'])
				&& count($request['answers']) > 0)
			{
				foreach ($request['answers'] as $answer) {
					if (strlen($answer['result']) <= 0) {
						$answ = '<span class="icon-unknown"></span> Unknown result for execution on the <b>'.$answer['server_name'].'</b> server on <i>'.$answer['command_dt'].'</i>';
					} else if ($answer['result'] == '0') {
						$answ = '<span class="icon-ok"></span>Command was successfully executed on the <b>'.$answer['server_name'].'</b> server on <i>'.$answer['command_dt'].'</i>';
					} else {
						$answ = '<span class="icon-error"></span>Execution of the command to the <b>'.$answer['server_name'].'</b> server on <i>'.$answer['command_dt'].'</i> <b>FAILED</b>';
					}
					$answers[$answer['server_name']] = $answ;
				}
			} else {
				$answers[] = '<span class="icon-info"></span> Waiting for processing';
			}
		?>
		<?php ksort($answers); ?>
		<?php echo implode('<br>', $answers)?>
		</td>
	</tr>
<?php } ?>
	</table>
<?php $old = $GLOBALS['platon_cluster_commands']->getRequestsCount(); $old -= 25; if ($old > 0) { ?>
	<p style="text-align: right;">+ <?php echo $old; ?> old requests</p>
<?php } ?>
</div>
<?php } ?>

</div>

<style type="text/css">
.w100 {
	max-width: 100% !important;
}
.wrap .wp-heading-inline {
	display: inline-block;
	margin-right: 5px;
}
.wrap .page-title-action {
	top: -1px;
}
.icon-info,
.icon-ok,
.icon-error,
.icon-unknown {
	display: inline-block;
	width: 17px;
	height: 17px;
	position: relative;
	top: 2px;
}
.icon-info {
	background-image: url("data:image/png;base64, <?php echo base64_encode(file_get_contents(plugin_dir_path(dirname( __FILE__ )).'assets/images/info.png')); ?>");
}
.icon-ok {
	background-image: url("data:image/png;base64, <?php echo base64_encode(file_get_contents(plugin_dir_path(dirname( __FILE__ )).'assets/images/ok.png')); ?>");
}
.icon-error {
	background-image: url("data:image/png;base64, <?php echo base64_encode(file_get_contents(plugin_dir_path(dirname( __FILE__ )).'assets/images/error.png')); ?>");
	top: 4px;
}
.icon-unknown {
	background-image: url("data:image/png;base64, <?php echo base64_encode(file_get_contents(plugin_dir_path(dirname( __FILE__ )).'assets/images/unknown.png')); ?>");
}
</style>
